/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.lib.reactivex.rxjava3.internal.operators.observable;

import dev.compactmods.crafting.lib.reactivex.rxjava3.core.Observable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.ObservableSource;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.Observer;
import dev.compactmods.crafting.lib.reactivex.rxjava3.disposables.CompositeDisposable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.disposables.Disposable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.exceptions.Exceptions;
import dev.compactmods.crafting.lib.reactivex.rxjava3.functions.BiFunction;
import dev.compactmods.crafting.lib.reactivex.rxjava3.functions.Function;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.disposables.DisposableHelper;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.util.ExceptionHelper;
import dev.compactmods.crafting.lib.reactivex.rxjava3.operators.SpscLinkedArrayQueue;
import dev.compactmods.crafting.lib.reactivex.rxjava3.plugins.RxJavaPlugins;
import dev.compactmods.crafting.lib.reactivex.rxjava3.subjects.UnicastSubject;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableGroupJoin<TLeft, TRight, TLeftEnd, TRightEnd, R>
extends AbstractObservableWithUpstream<TLeft, R> {
    final ObservableSource<? extends TRight> other;
    final Function<? super TLeft, ? extends ObservableSource<TLeftEnd>> leftEnd;
    final Function<? super TRight, ? extends ObservableSource<TRightEnd>> rightEnd;
    final BiFunction<? super TLeft, ? super Observable<TRight>, ? extends R> resultSelector;

    public ObservableGroupJoin(ObservableSource<TLeft> source, ObservableSource<? extends TRight> other, Function<? super TLeft, ? extends ObservableSource<TLeftEnd>> leftEnd, Function<? super TRight, ? extends ObservableSource<TRightEnd>> rightEnd, BiFunction<? super TLeft, ? super Observable<TRight>, ? extends R> resultSelector) {
        super(source);
        this.other = other;
        this.leftEnd = leftEnd;
        this.rightEnd = rightEnd;
        this.resultSelector = resultSelector;
    }

    @Override
    protected void subscribeActual(Observer<? super R> observer) {
        GroupJoinDisposable parent = new GroupJoinDisposable(observer, this.leftEnd, this.rightEnd, this.resultSelector);
        observer.onSubscribe(parent);
        LeftRightObserver left = new LeftRightObserver(parent, true);
        parent.disposables.add(left);
        LeftRightObserver right = new LeftRightObserver(parent, false);
        parent.disposables.add(right);
        this.source.subscribe(left);
        this.other.subscribe(right);
    }

    static final class LeftRightEndObserver
    extends AtomicReference<Disposable>
    implements Observer<Object>,
    Disposable {
        private static final long serialVersionUID = 1883890389173668373L;
        final JoinSupport parent;
        final boolean isLeft;
        final int index;

        LeftRightEndObserver(JoinSupport parent, boolean isLeft, int index) {
            this.parent = parent;
            this.isLeft = isLeft;
            this.index = index;
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)this.get());
        }

        @Override
        public void onSubscribe(Disposable d) {
            DisposableHelper.setOnce(this, d);
        }

        @Override
        public void onNext(Object t) {
            if (DisposableHelper.dispose(this)) {
                this.parent.innerClose(this.isLeft, this);
            }
        }

        @Override
        public void onError(Throwable t) {
            this.parent.innerCloseError(t);
        }

        @Override
        public void onComplete() {
            this.parent.innerClose(this.isLeft, this);
        }
    }

    static final class LeftRightObserver
    extends AtomicReference<Disposable>
    implements Observer<Object>,
    Disposable {
        private static final long serialVersionUID = 1883890389173668373L;
        final JoinSupport parent;
        final boolean isLeft;

        LeftRightObserver(JoinSupport parent, boolean isLeft) {
            this.parent = parent;
            this.isLeft = isLeft;
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)this.get());
        }

        @Override
        public void onSubscribe(Disposable d) {
            DisposableHelper.setOnce(this, d);
        }

        @Override
        public void onNext(Object t) {
            this.parent.innerValue(this.isLeft, t);
        }

        @Override
        public void onError(Throwable t) {
            this.parent.innerError(t);
        }

        @Override
        public void onComplete() {
            this.parent.innerComplete(this);
        }
    }

    static final class GroupJoinDisposable<TLeft, TRight, TLeftEnd, TRightEnd, R>
    extends AtomicInteger
    implements Disposable,
    JoinSupport {
        private static final long serialVersionUID = -6071216598687999801L;
        final Observer<? super R> downstream;
        final SpscLinkedArrayQueue<Object> queue;
        final CompositeDisposable disposables;
        final Map<Integer, UnicastSubject<TRight>> lefts;
        final Map<Integer, TRight> rights;
        final AtomicReference<Throwable> error;
        final Function<? super TLeft, ? extends ObservableSource<TLeftEnd>> leftEnd;
        final Function<? super TRight, ? extends ObservableSource<TRightEnd>> rightEnd;
        final BiFunction<? super TLeft, ? super Observable<TRight>, ? extends R> resultSelector;
        final AtomicInteger active;
        int leftIndex;
        int rightIndex;
        volatile boolean cancelled;
        static final Integer LEFT_VALUE = 1;
        static final Integer RIGHT_VALUE = 2;
        static final Integer LEFT_CLOSE = 3;
        static final Integer RIGHT_CLOSE = 4;

        GroupJoinDisposable(Observer<? super R> actual, Function<? super TLeft, ? extends ObservableSource<TLeftEnd>> leftEnd, Function<? super TRight, ? extends ObservableSource<TRightEnd>> rightEnd, BiFunction<? super TLeft, ? super Observable<TRight>, ? extends R> resultSelector) {
            this.downstream = actual;
            this.disposables = new CompositeDisposable();
            this.queue = new SpscLinkedArrayQueue(Observable.bufferSize());
            this.lefts = new LinkedHashMap<Integer, UnicastSubject<TRight>>();
            this.rights = new LinkedHashMap<Integer, TRight>();
            this.error = new AtomicReference();
            this.leftEnd = leftEnd;
            this.rightEnd = rightEnd;
            this.resultSelector = resultSelector;
            this.active = new AtomicInteger(2);
        }

        @Override
        public void dispose() {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
            this.cancelAll();
            if (this.getAndIncrement() == 0) {
                this.queue.clear();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void cancelAll() {
            this.disposables.dispose();
        }

        void errorAll(Observer<?> a) {
            Throwable ex = ExceptionHelper.terminate(this.error);
            for (UnicastSubject<TRight> up : this.lefts.values()) {
                up.onError(ex);
            }
            this.lefts.clear();
            this.rights.clear();
            a.onError(ex);
        }

        void fail(Throwable exc, Observer<?> a, SpscLinkedArrayQueue<?> q) {
            Exceptions.throwIfFatal(exc);
            ExceptionHelper.addThrowable(this.error, exc);
            q.clear();
            this.cancelAll();
            this.errorAll(a);
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            SpscLinkedArrayQueue<Object> q = this.queue;
            Observer<R> a = this.downstream;
            block6: while (true) {
                boolean empty;
                if (this.cancelled) {
                    q.clear();
                    return;
                }
                Throwable ex = this.error.get();
                if (ex != null) {
                    q.clear();
                    this.cancelAll();
                    this.errorAll(a);
                    return;
                }
                boolean d = this.active.get() == 0;
                Integer mode = (Integer)q.poll();
                boolean bl = empty = mode == null;
                if (d && empty) {
                    for (UnicastSubject<TRight> up : this.lefts.values()) {
                        up.onComplete();
                    }
                    this.lefts.clear();
                    this.rights.clear();
                    this.disposables.dispose();
                    a.onComplete();
                    return;
                }
                if (!empty) {
                    LeftRightEndObserver end;
                    Object val = q.poll();
                    if (mode == LEFT_VALUE) {
                        R w;
                        ObservableSource<TLeftEnd> p;
                        int idx;
                        Object left = val;
                        UnicastSubject<TRight> up = UnicastSubject.create();
                        ++this.leftIndex;
                        this.lefts.put(idx, up);
                        try {
                            p = Objects.requireNonNull(this.leftEnd.apply(left), "The leftEnd returned a null ObservableSource");
                        }
                        catch (Throwable exc) {
                            this.fail(exc, a, q);
                            return;
                        }
                        LeftRightEndObserver end2 = new LeftRightEndObserver(this, true, idx);
                        this.disposables.add(end2);
                        p.subscribe(end2);
                        ex = this.error.get();
                        if (ex != null) {
                            q.clear();
                            this.cancelAll();
                            this.errorAll(a);
                            return;
                        }
                        try {
                            w = Objects.requireNonNull(this.resultSelector.apply(left, up), "The resultSelector returned a null value");
                        }
                        catch (Throwable exc) {
                            this.fail(exc, a, q);
                            return;
                        }
                        a.onNext(w);
                        Iterator<TRight> iterator = this.rights.values().iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block6;
                            TRight right = iterator.next();
                            up.onNext(right);
                        }
                    }
                    if (mode == RIGHT_VALUE) {
                        ObservableSource<TRightEnd> p;
                        int idx;
                        Object right = val;
                        ++this.rightIndex;
                        this.rights.put(idx, right);
                        try {
                            p = Objects.requireNonNull(this.rightEnd.apply(right), "The rightEnd returned a null ObservableSource");
                        }
                        catch (Throwable exc) {
                            this.fail(exc, a, q);
                            return;
                        }
                        LeftRightEndObserver end3 = new LeftRightEndObserver(this, false, idx);
                        this.disposables.add(end3);
                        p.subscribe(end3);
                        ex = this.error.get();
                        if (ex != null) {
                            q.clear();
                            this.cancelAll();
                            this.errorAll(a);
                            return;
                        }
                        Iterator<UnicastSubject<TRight>> iterator = this.lefts.values().iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block6;
                            UnicastSubject<TRight> up = iterator.next();
                            up.onNext(right);
                        }
                    }
                    if (mode == LEFT_CLOSE) {
                        end = (LeftRightEndObserver)val;
                        UnicastSubject<TRight> up = this.lefts.remove(end.index);
                        this.disposables.remove(end);
                        if (up == null) continue;
                        up.onComplete();
                        continue;
                    }
                    end = (LeftRightEndObserver)val;
                    this.rights.remove(end.index);
                    this.disposables.remove(end);
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        @Override
        public void innerError(Throwable ex) {
            if (ExceptionHelper.addThrowable(this.error, ex)) {
                this.active.decrementAndGet();
                this.drain();
            } else {
                RxJavaPlugins.onError(ex);
            }
        }

        @Override
        public void innerComplete(LeftRightObserver sender) {
            this.disposables.delete(sender);
            this.active.decrementAndGet();
            this.drain();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void innerValue(boolean isLeft, Object o) {
            GroupJoinDisposable groupJoinDisposable = this;
            synchronized (groupJoinDisposable) {
                this.queue.offer(isLeft ? LEFT_VALUE : RIGHT_VALUE, o);
            }
            this.drain();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void innerClose(boolean isLeft, LeftRightEndObserver index) {
            GroupJoinDisposable groupJoinDisposable = this;
            synchronized (groupJoinDisposable) {
                this.queue.offer(isLeft ? LEFT_CLOSE : RIGHT_CLOSE, index);
            }
            this.drain();
        }

        @Override
        public void innerCloseError(Throwable ex) {
            if (ExceptionHelper.addThrowable(this.error, ex)) {
                this.drain();
            } else {
                RxJavaPlugins.onError(ex);
            }
        }
    }

    static interface JoinSupport {
        public void innerError(Throwable var1);

        public void innerComplete(LeftRightObserver var1);

        public void innerValue(boolean var1, Object var2);

        public void innerClose(boolean var1, LeftRightEndObserver var2);

        public void innerCloseError(Throwable var1);
    }
}

